using System;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Counting trigger. Used to set data load mode in variouse forms.
	/// When lock is called multiple times trigger remains locked until release is not
	/// called for the same (or exceeding) number of times. 
	/// </summary>
	public class CountingTrigger
	{
		private int _lockRequests = 0;

		/// <summary>
		/// Makes trigger to lock.
		/// </summary>
		public void Lock()
		{
			_lockRequests++;
		}

		/// <summary>
		/// Unlocks trigger. 
		/// </summary>
		public void Release()
		{
			if( --_lockRequests < 0 )
				_lockRequests = 0;
		}

		/// <summary>
		/// Indicates if the trigger is locked or not. 
		/// </summary>
		public bool IsLocked
		{
			get
			{
				return _lockRequests > 0;
			}
		}
	}
}
